entity Testbench
end entity Testbench;

architecture TB of Testbench is

    signal clk : std_logic;
    signal rst : std_logic;

    signal spi : spi_bus_3slv.spi_r;

begin
    DUT: entity work.FPGA
        port map (
            clk => clk,
            rst => rst,
--            ...
            -- Because qspi_master is a view onto the spi_r, this
            -- mapping is allowable.
            spi => spi,
        );

    MEMORY: entity work.qspi_flash
        generic map (
            CS  => 0
        ) port map (
            -- This mapping is where the chip select is selected
            -- using the CS generic above.
            spi => spi
        );

    ADC: entity work.spi_adc
        generic map (
            CS  => 1,
            VREF => 3.0
        ) port map (
            spi => spi,
            adc => monitored_voltage
        );

    DAC: entity work.spi_dac
        generic map (
            CS  => 2,
            VREF => 3.0
        ) port map (
            spi => spi,
            aout => driven_voltage
        );

    -- And our resistive pullups.
    spi.miso <= (others => 'Z');

end architecture TB;
