entity spi_dac
    generic (
        CS  : spi_bus_3slv.ssel_rng;
        VREF: real;
        Ts  : time := 5 ns;
    );
    port (
        spi  : view spi_bus_3slv.spi_slave generic map (IDX => CS);
        aout : out real;
    );
end entity spi_dac;

architecture Behavioral of spi_dac is
begin

    SIM: process
        variable dacdata : std_logic_vector(15 downto 0);
        constant dout : std_logic_vector(15 downto 0) := (others => 'Z');
    begin
        wait until cs = '0';
        spi_bits(spi, 16, dout, dacdata, 0 ns, Ts);
        aout <= REAL(TO_INTEGER(UNSIGNED(data))) * VREF/65536.0;
    end process SIM;
end architecture Behavioral;
