package spi_bus_pkg is
    generic(
        CHIP_SELECTS : positive
    );

    subtype ssel_rng is natural range CHIP_SELECTS-1 downto 0;
    subtype ssel_vst is std_logic_vector(ssel_rng);

    type spi_r is record
        mosi : std_logic_vector(3 downto 0);  -- Data from master to slave
        miso : std_logic_vector(3 downto 0);  -- Data from slave to master
        sclk : std_logic;                     -- Serial clock
        ssel : ssel_vst                       -- Chip selects
    end record spi_r;

    record view qspi_master_view of spi_r is
        element(
            mosi : out;
            miso : in;
            sclk : out;
            ssel : out
        );
    end record view qspi_master_view;

    record view qspi_slave of spi_r is
        generic(
            IDX : ssel_rng
        );
        element(
            mosi : in;
            miso : out;
            sclk : in;
            cs   : in std_logic is ssel(IDX)
        );
    end record view qspi_slave;

    record view spi_slave of spi_r is
        generic(
            IDX : ssel_rng
        );
        element(
            din  : in  std_logic is mosi(0);
            dout : out std_logic is miso(0);
            sclk : in;
            cs   : in  std_logic is ssel(IDX)
        );
    end record view spi_slave;
end package spi_bus_pkg;
