procedure spi_bits (
    view spi  : spi_slave;
    signal bits : in  positive;
    signal xmit : in  std_logic_vector;
    signal recv : out std_logic_vector;

    Tpd  : in  time;
    Ts   : in  time
) is
    variable xd : std_logic_vector(bits-1 downto 0);
    variable rd : std_logic_vector(bits-1 downto 0);
begin
    xd := xmit;
    for i in range 0 to bits-1 loop
        wait until spi.sclk = '1';
        spi.dout <= xd(bits-i-1) after Tpd;
        rd(i) := spi.din'delayed(Ts);
    end loop;
    recv := rd;
end procedure spi_bits;
