entity spi_adc
    generic (
        CS  : spi_bus_3slv.ssel_rng;
        VREF: real;
        Tpd : time := 5 ns;
        Ts  : time := 5 ns;
    );
    port (
        spi  : view spi_bus_3slv.spi_slave generic map (IDX => CS);
        ain  : in real;
    );
end entity spi_adc;

architecture Behavioral of spi_adc is
begin

    SIM: process
        variable adcdata : std_logic_vector(15 downto 0);
        variable cmd : std_logic_vector(15 downto 0);
    begin
        spi.dout <= 'Z'
        wait until cs = '0';
        adcdata := STD_LOGIC_VECTOR(TO_UNSIGNED(INTEGER(ain * 65536.0 / VREF), 16));
        spi_bits(spi, 16, adcdata, cmd, Tpd, Ts);
        case cmd is
        --                ...
        end case;
    end process SIM;
end architecture Behavioral;
