library ieee;
use ieee.std_logic_1164.all;
use work.spi_bus_3slv.all;
entity Testbench is
end entity Testbench;

architecture TB of Testbench is

    signal clk : std_logic;
    signal rst : std_logic;

    signal spim : spi_m2s;
    signal spis : spi_s2m;

    signal monitored_voltage, driven_voltage: real;
begin
    DUT: entity work.FPGA
        port map (
            clk => clk,
            rst => rst,
--            ...
            -- Because qspi_master is a view onto the spi_r, this
            -- mapping is allowable.
            spim => spim,
            spis => spis
        );

    MEMORY: entity work.qspi_flash
        generic map (
            CS  => 0
        ) port map (
            -- This mapping is where the chip select is selected
            -- using the CS generic above.
            spim => spim,
            spis => spis
        );

    ADC: entity work.spi_adc
        generic map (
            CS  => 1,
            VREF => 3.0
        ) port map (
            spim => spim,
            spis => spis,
            ain => monitored_voltage
        );

    DAC: entity work.spi_dac
        generic map (
            CS  => 2,
            VREF => 3.0
        ) port map (
            spim => spim,
            spis => spis,
            aout => driven_voltage
        );

    -- And our resistive pullups.
    spis.miso <= (others => 'Z');

end architecture TB;
