library ieee;
use ieee.std_logic_1164.all;
use work.spi_bus_3slv.all;
use work.spi_proc.all;
entity spi_dac is
    generic (
        CS  : ssel_rng;
        VREF: real;
        Ts  : time := 5 ns
    );
    port (
        spim  : in spi_m2s;
        spis  : out spi_s2m;
--        spi  : view spi_bus_3slv.spi_slave generic map (IDX => CS);
        aout : out real
    );
end entity spi_dac;

architecture Behavioral of spi_dac is
    signal dacdata : std_logic_vector(15 downto 0);
begin

    SIM: process
--        variable dacdata : std_logic_vector(15 downto 0);
        constant dout : std_logic_vector(15 downto 0) := (others => 'Z');
    begin
        wait until spim.ssel(cs) = '0';
        spi_bits(spim, spis, CS, 16, dout, dacdata, 0 ns, Ts);
        aout <= 1.0; -- REAL(TO_INTEGER(UNSIGNED(data))) * VREF/65536.0;
    end process SIM;
end architecture Behavioral;
