library ieee;
use ieee.std_logic_1164.all;
package spi_bus_pkg is
    generic(
        CHIP_SELECTS : positive
    );

    subtype ssel_rng is natural range CHIP_SELECTS-1 downto 0;
    subtype ssel_vst is std_logic_vector(ssel_rng);

    type spi_m2s_base is record
        mosi : std_logic_vector;            -- Data from master to slave
        sclk : std_logic;                   -- Serial clock
        ssel : ssel_vst;                    -- Chip selects
    end record spi_m2s_base;

    subtype spi_m2s is        spi_m2s_base (mosi(3 downto 0));
--    subtype qspi_m2s_slave is spi_m2s_base (mosi(3 downto 0));
--    subtype spi_m2s_slave is  spi_m2s_base (mosi(0 to 0));
--    alias spi_m2s_din  is spi_m2s.mosi(0);
        
    type spi_s2m_base is record
        miso : std_logic_vector;            -- Data from slave to master
    end record spi_s2m_base;

    subtype spi_s2m       is spi_s2m_base (miso(3 downto 0));
--    subtype spi_s2m_slave is spi_s2m_base (miso(0 to 0));
--    alias spi_s2m_dout is spi_s2m.miso(0);

--    type spi_r is record
--        mosi : std_logic_vector(3 downto 0);  -- Data from master to slave
--        miso : std_logic_vector(3 downto 0);  -- Data from slave to master
--        sclk : std_logic;                     -- Serial clock
--        ssel : ssel_vst;                      -- Chip selects
--    end record spi_r;
--      corresponds to spi_m2s+spi_s2m
--
--    record view qspi_master_view of spi_r is
--        element(
--            mosi : out;
--            miso : in;
--            sclk : out;
--            ssel : out
--        );
--    end record view qspi_master_view;
--
--    record view qspi_slave of spi_r is
--        generic(
--            IDX : ssel_rng
--        );
--        element(
--            mosi : in;
--            miso : out;
--            sclk : in;
--            cs   : in std_logic is ssel(IDX)
--        );
--    end record view qspi_slave;
--      corresponds to qspi_m2s_slave+spi_s2m
--
--    record view spi_slave of spi_r is
--        generic(
--            IDX : ssel_rng
--        );
--        element(
--            din  : in  std_logic is mosi(0);
--            dout : out std_logic is miso(0);
--            sclk : in;
--            cs   : in  std_logic is ssel(IDX)
--        );
--    end record view spi_slave;
--      corresponds to spi_m2s_slave+spi_s2m_slave
end package spi_bus_pkg;
