library ieee;
use ieee.std_logic_1164.all;
use work.spi_bus_3slv.all;
package spi_proc is
    procedure spi_bits (
        signal spim : in spi_m2s;
        signal spis : out spi_s2m;
        constant cs : in ssel_rng;
        constant bits : in  positive;
        constant xmit : in  std_logic_vector;
        signal recv : out std_logic_vector;

        Tpd  : in  time;
        Ts   : in  time
    );
end package spi_proc;

package body spi_proc is
    procedure spi_bits (
        signal spim : in spi_m2s;
        signal spis : out spi_s2m;
        constant cs : in ssel_rng;
        constant bits : in  positive;
        constant xmit : in  std_logic_vector;
        signal recv : out std_logic_vector;

        Tpd  : in  time;
        Ts   : in  time
    ) is
        variable xd : std_logic_vector(bits-1 downto 0);
        variable rd : std_logic_vector(bits-1 downto 0);
    begin
        xd := xmit;
        for i in 0 to bits-1 loop
            wait until spim.sclk = '1';
            spis.miso(0) <= xd(bits-i-1) after Tpd;
            rd(i) := spim.mosi(0); --'delayed(Ts); -- not allowed in subprogram
        end loop;
        recv <= rd;
    end procedure spi_bits;
end package body spi_proc;
