library ieee;
use ieee.std_logic_1164.all;
use work.spi_bus_3slv.all;
use work.spi_proc.all;
entity spi_adc is
    generic (
        CS  : ssel_rng;
        VREF: real;
        Tpd : time := 5 ns;
        Ts  : time := 5 ns
    );
    port (
        spim : in spi_m2s;
        spis : out spi_s2m;
--        spi  : view spi_bus_3slv.spi_slave generic map (IDX => CS);
        ain  : in real
    );
end entity spi_adc;

architecture Behavioral of spi_adc is
    signal cmd : std_logic_vector(15 downto 0);
begin

    SIM: process
        variable adcdata : std_logic_vector(15 downto 0);
--        variable cmd : std_logic_vector(15 downto 0);
    begin
        spis.miso(0) <= 'Z';
        wait until spim.ssel(cs) = '0';
--        adcdata := STD_LOGIC_VECTOR(TO_UNSIGNED(INTEGER(ain * 65536.0 / VREF), 16));
        spi_bits(spim, spis, cs, 16, adcdata, cmd, Tpd, Ts);
--        case cmd is
        --                ...
--        end case;
    end process SIM;
end architecture Behavioral;
