library ieee;
use ieee.std_logic_1164.all;
use work.cpu_bus_2m8s_pkg.all;
entity slave_ent is
      generic (
         slave_id_jg : slaves_total_jrt
      );
      port (
         signal rst_i       : in     std_logic;
         signal clk_i       : in     std_logic;
         bundle cpu_bus_rif : view   slave_ivw 
                                          generic map(
                                             slave_id_jg => slave_id_jg
                                          )
      );
end entity slave_ent;

architecture rtl_arch of slave_ent is
         alias add_vs      is cpu_bus_rif.master_rl.addr_vl;
         alias data_in_vs  is cpu_bus_rif.master_rl.data_vl;
         alias we_s        is cpu_bus_rif.master_rl.we_l;
         alias en_s        is cpu_bus_rif.master_rl.en_vl(slave_id_jg);

         alias data_out_vs is cpu_bus_rif.slave_rl.data_vl;
         alias ack_s       is cpu_bus_rif.slave_rl.ack_l;
         alias err_s       is cpu_bus_rif.slave_rl.err_l;
begin

--      ...

end architecture rtl_arch;

