library ieee;
use ieee.std_logic_1164.all;
use work.cpu_bus_2m8s_pkg.all;
entity master_ent is
       generic (
         slave_id_jg  : slaves_total_jrt;
         master_id_jg : masters_total_jrt
       );
       port (
         signal rst_i       : in     std_logic;
         signal clk_i       : in     std_logic;
         bundle cpu_bus_rif : view   master_ivw
                                 generic map(
                                    slave_id_jg => slave_id_jg,
                                    master_id_jg => master_id_jg
                                 )                       
        );
end entity master_ent;

architecture rtl_arch  of master_ent is
      -- Master bus and controls to/from arbiter instance
      alias addr_vs     is cpu_bus_rif.arbiter_rl.master_rl.addr_vl;
      alias data_vs     is cpu_bus_rif.arbiter_rl.master_rl.data_vl;
      alias we_s        is cpu_bus_rif.arbiter_rl.master_rl.we_l;
      alias en_vs       is cpu_bus_rif.arbiter_rl.master_rl.en_vl;
      alias bus_req_s   is cpu_bus_rif.arbiter_rl.bus_req_l;
      alias bus_grnt_s  is cpu_bus_rif.arbiter_rl.bus_grnt_l;

      -- Selected master bus input from arbiter instance
      alias addr_in_vs  is cpu_bus_rif.master_rl.addr_in_vl;
      alias data_in_vs  is cpu_bus_rif.master_rl.data_in_vl;
      alias we_in_s     is cpu_bus_rif.master_rl.we_in_l;
      alias en_in_s     is cpu_bus_rif.master_rl.en_in_vl(slave_id_jg);

      -- Return slave bus output when not selected as master
      alias data_out_vs is cpu_bus_rif.slave_al(slave_id_jg).data_vl;
      alias ack_out_s   is cpu_bus_rif.slave_al(slave_id_jg).ack_l;
      alias err_out_s   is cpu_bus_rif.slave_al(slave_id_jg).err_l;

      -- Input slave array when selected as master
      alias s_slave_as  is cpu_bus_rif.slave_al;

begin

      ...

end architecture rtl_arch;

