library ieee;
use ieee.std_logic_1164.all;
use work.cpu_bus_2m8s_pkg.all;
entity arbiter_ent is
       generic (
         slave_id_jg  : slaves_total_jrt
       );
       port (
         signal rst_i       : in     std_logic;
         signal clk_i       : in     std_logic;
         bundle cpu_bus_rif : view   arbiter_ivw
                                 generic map(
                                    slave_id_jg => slave_id_jg
                                 )
       );
end entity arbiter_ent;

architecture rtl_arch  of arbiter_ent is
      -- Arbiter interface
      alias arbiter_as  is cpu_bus_rif.arbiter_al;

      -- Arbiter slave access to selected master 
      alias data_out_vs is cpu_bus_rif.slave_rl.data_vl;
      alias ack_out_s   is cpu_bus_rif.slave_rl.ack_l;
      alias err_out_s   is cpu_bus_rif.slave_rl.err_l;

      -- Master bus and controls to/from arbiter instance
      signal bus_req_vs  : std_logic_vector(masters_total_jrt);
      signal bus_grnt_vs : std_logic_vector(masters_total_jrt);

      -- Selected master bus input from arbiter array
      signal addr_in_vs  : addr_vst;
      signal data_in_vs  : data_vst;
      signal we_in_s     : std_logic;
      signal en_in_vs    : slave_ctrl_vst;

begin
      ...

      -- Generate bus request vector and return bus grant vector
      for i_jv in masters_total_jrt loop
         bus_req_vs(i_jv - 1) <= cpu_bus_rif.arbiter_al(i_jv - 1).bus_grnt_l;

         if (i_jv - 1 = m_select_jg - 1) then
            cpu_bus_rif.arbiter_al(i_jv - 1).bus_grnt_l <= '1';
         else
            cpu_bus_rif.arbiter_al(i_jv - 1).bus_grnt_l <= '0';
         end if;
      end loop;

      -- Selected master bus for arbiter slave accesses
      addr_in_vs <= arbiter_as(m_select_jg - 1).master_rl.addr_vl;
      data_in_vs <= arbiter_as(m_select_jg - 1).master_rl.data_vl;
      we_in_s    <= arbiter_as(m_select_jg - 1).master_rl.we_l;
      en_in_vs   <= arbiter_as(m_select_jg - 1).master_rl.en_vl;


      -- Selected master interface from arbiter to slaves on CPU bus interface
      cpu_bus_rif.master_rl <= arbiter_as(m_select_jg - 1).master_rl;

      ...

end architecture rtl_arch;

