library ieee;
use ieee.std_logic_1164.all;
use work.cpu_bus_2m8s_pkg.all;
entity Sonly_ent is
      port(
         signal rst_i       : in     std_logic;
         signal clk_i       : in     std_logic;
         bundle cpu_bus_rif : view   cpu_bus_i
                  mode map(
                      master_rl  => in;
                      slave_al   => view slave_a
                              mode map(0|5 => buffer)
                  )
      );
end entity Sonly_ent;

architecture rtl_arch of Sonly_ent is
begin
      slave_inst1 : entity work.slave_ent
         generic map(
            slave_id_jg => 0
         )
         port map(
            rst_i       => rst_i,
            clk_i       => clk_i,
            cpu_bus_rif => cpu_bus_rif
         );

      slave_inst6 : entity work.slave_ent
         generic map(
            slave_id_jg => 5
         )
         port map(
            rst_i       => rst_i,
            clk_i       => clk_i,
            cpu_bus_rif => cpu_bus_rif
         );
end architecture rtl_arch;

