library ieee;
use ieee.std_logic_1164.all;
use work.cpu_bus_2m8s_pkg.all;
entity MplusS_ent is
      port(
         signal rst_i       : in     std_logic;
         signal clk_i       : in     std_logic;
         bundle cpu_bus_rif : view   cpu_bus_i
                           mode map(
                              arbiter_rl : view arbiter_a
                                       mode map(0 => view arbiter_v_in),
                              master_rl  : in   master_r,
                              slave_al   : view slave_a
                                       mode map(2|4|8 => buffer, others => in)
                              )
      );
end entity MplusS_ent;

architecture rtl_arch of MplusS_ent is
begin
      master_inst1 : entity work.master_ent
         generic map(
            slave_id_jg  => 8,
            master_id_jg => 0
         )
         port map(
            rst_i       => rst_i,
            clk_i       => clk_i,
            cpu_bus_rif => cpu_bus_rif
         );

      slave_inst3 : entity work.slave_ent
         generic map(
            slave_id_jg => 2
         )
         port map(
            rst_i       => rst_i,
            clk_i       => clk_i,
            cpu_bus_rif => cpu_bus_rif
         );

      slave_inst5 : entity work.slave_ent
         generic map(
            slave_id_jg => 4
         )
         port map(
            rst_i       => rst_i,
            clk_i       => clk_i,
            cpu_bus_rif => cpu_bus_rif
         );
end architecture rtl_arch;

