library ieee;
use ieee.std_logic_1164.all;
use work.cpu_bus_2m8s_pkg.all;
entity CPU_Bus_top_ent
      port(
         rst_i       : in     std_logic;
         clk_i       : in     std_logic
      );
end entity CPU_Bus_top_ent;

architecture rtl_arch of CPU_Bus_top_ent is
      signal rst_s      : std_logic;
      signal clk_s      : std_logic;
      signal cpu_bus_rs : cpu_bus_i;
begin
      Sonly_inst : entity work.Sonly_ent
         port map(
            rst_i       => rst_s,
            clk_i       => clk_s,
            cpu_bus_rif => cpu_bus_rs
         );

      MplusS_inst : entity work.MplusS_ent
         port map(
            rst_i       => rst_s,
            clk_i       => clk_s,
            cpu_bus_rif => cpu_bus_rs
         );

      AMandS_inst : entity work.AMandS_ent
         port map(
            rst_i       => rst_s,
            clk_i       => clk_s,
            cpu_bus_rif => cpu_bus_rs
         );

      slave_inst2 : entity work.slave_ent
         generic map(
            slave_id_jg => 1
         )
         port map(
            rst_i       => rst_s,
            clk_i       => clk_s,
            cpu_bus_rif => cpu_bus_rs
         );

      slave_inst7 : entity work.slave_ent
         generic map(
            slave_id_jg => 6
         )
         port map(
            rst_i       => rst_s,
            clk_i       => clk_s,
            cpu_bus_rif => cpu_bus_rs
         );

--      ...

end architecture rtl_arch;

