library ieee;
use ieee.std_logic_1164.all;
use work.cpu_bus_2m8s_pkg.all;
entity AMandS_ent is
      port(
         signal rst_i       : in     std_logic;
         signal clk_i       : in     std_logic;
         bundle cpu_bus_rif : view   cpu_bus_i
                mode map(arbiter_al => view   arbiter_a
                                  mode map(0 => arbiter_v_out),
                         master_rl  => buffer master_r,
                         slave_al   => view   slave_a
                                  mode map(3|7|9|10 => buffer, others => in)
                        )
      );
end entity AMandS_ent;

architecture rtl_arch of AMandS_ent is
begin
      arbiter_inst : entity work.arbiter_ent
         generic map(
            slave_id_jg  => 10
         )
         port map(
            rst_i       => rst_i,
            clk_i       => clk_i,
            cpu_bus_rif => cpu_bus_rif
         );

      master_inst2 : entity work.master_ent
         generic map(
            slave_id_jg  => 9,
            master_id_jg => 1
         )
         port map(
            rst_i       => rst_i,
            clk_i       => clk_i,
            cpu_bus_rif => cpu_bus_rif
         );

      slave_inst4 : entity work.slave_ent
         generic map(
            slave_id_jg => 3
         )
         port map(
            rst_i       => rst_i,
            clk_i       => clk_i,
            cpu_bus_rif => cpu_bus_rif
         );

      slave_inst8 : entity work.slave_ent
         generic map(
            slave_id_jg => 7
         )
         port map(
            rst_i       => rst_i,
            clk_i       => clk_i,
            cpu_bus_rif => cpu_bus_rif
         );
end architecture rtl_arch;

